// Gwny plik programu - BezpiecznyProgram.cpp

#include "stdafx.h"
#include "BezpiecznyProgram.h"
#include "WsparcieKluczy.h"
#include "WsparcieSzyfrowania.h"
#include "KolorDlgs.h"
#include "resource.h" 

// Zmienne globalne
HINSTANCE hInst;								
TCHAR szTitle[MAX_LOADSTRING];					
TCHAR szWindowClass[MAX_LOADSTRING];			
COLORREF clrKolorTla;							// Kolor ta (RGB)
COLORREF clrKolorTekstu;						// Kolor tekstu (RGB)
char *hasloWWW;
const int MAX_HASLO_WWW = 50;

// Deklaracje funkcji zawartych w tym pliku
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	DialogSerial(HWND, UINT, WPARAM, LPARAM);
INT_PTR CALLBACK	DialogHaslo(HWND, UINT, WPARAM, LPARAM);
void				UtworzTekstKoloru(char * szMessage, COLORREF aColor, char * aHasloWWW = NULL);

// punkt wejcia do programu
int APIENTRY _tWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
{

	hasloWWW = NULL;
	if( !strcmp(lpCmdLine, "tajnehaslo"))
	{
		// tryb pracy programu - zrzut zabezpieczanego fragmentu
		UtworzTekstKoloru(NULL, clrKolorTekstu,  NULL);
		return 0;
	}
	else
	{
	    UNREFERENCED_PARAMETER(hPrevInstance);
		UNREFERENCED_PARAMETER(lpCmdLine);
		MSG msg;
		HACCEL hAccelTable;

		LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
		LoadString(hInstance, IDC_HELLOCPP, szWindowClass, MAX_LOADSTRING);
		MyRegisterClass(hInstance);

		if (!InitInstance (hInstance, nCmdShow))
		{
			return FALSE;
		}

		hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_HELLOCPP));

		while (GetMessage(&msg, NULL, 0, 0))
		{
			if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
	}
	if(hasloWWW != NULL)
		delete hasloWWW;
	return (int) msg.wParam;
	}
}

// Funkcja MyRegisterClass
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX);

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_HELLOCPP));
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= MAKEINTRESOURCE(IDC_HELLOCPP);
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_SMALL));

	return RegisterClassEx(&wcex);
}

// Inicjalizacja aplikacji
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   clrKolorTekstu = 0;
   clrKolorTla = 0xFFFFFF;
   
   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

// WndProc - przetwarzanie komunikatw
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	char msgText[40];
	switch (message)
	{
	case WM_CREATE:
		// sprawdzenie czy istnieje plik z kluczem programowym, jeli tak to uznajemy program za aktywowany, jeli kto wprowadzi bdny klucz to program
		// wykona si nieprawidowo
		if(! PlikIstnieje("klucz_programowy.dat"))
		{
			DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_SERIAL), hWnd, DialogSerial);
			// ponownie sprawdzamy, bo by moe uytkownik wanie aktywowa program
			// jeli nie, to dalsza praca nie ma sensu, ale jeli kto zkrakuje t lini kodu to i tak nie uruchomi prawidowego programu
			if(! PlikIstnieje("klucz_programowy.dat") || hasloWWW == NULL)
				DestroyWindow(hWnd);
		}
		else
		{  // pytamy o haso, wzgldnie moemy zapisa gdzie to haso (zabezpiecz je w takiej sytuacji np. szyfrujc aby kto nie ukrad go uytkownikowi!)
			DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_HASLO), hWnd, DialogHaslo);
			if(hasloWWW == NULL)
				DestroyWindow(hWnd);
		}
		break;
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		// Obsuga menu
		switch (wmId)
		{
		case IDM_ABOUT:
			DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUTBOX), hWnd, About);
			break;
		case IDM_KOLOR_TEKSTU1:
  		    DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_KOLOR_TEKSTU), hWnd, KolorTekstu);
			InvalidateRect(hWnd, NULL, TRUE);
			break;
		case IDM_KOLOR_TLA1:
 		    DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_KOLOR_TLA), hWnd, KolorTla);
			InvalidateRect(hWnd, NULL, TRUE);
			break;
		case IDM__WERSJA1:
			MessageBox(hWnd, "BezpiecznyProgram - Demonstracja wielu zabezpiecze", "Wersja BezpiecznyProgram 1.0", MB_OK);    
			break;
		case IDM__WYBRANY_KOLOR1:
			if(PlikIstnieje("klucz_programowy.dat") && hasloWWW != NULL)
			{
  			   UtworzTekstKoloru(msgText, clrKolorTla, hasloWWW);
			   MessageBox(hWnd, msgText , "Kolor ta", MB_OK);    
			   UtworzTekstKoloru(msgText, clrKolorTekstu, hasloWWW);
			   MessageBox(hWnd, msgText, "Kolor tekstu", MB_OK);    
			}
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	case WM_PAINT:
		// narysowanie tekstu w oknie
		hdc = BeginPaint(hWnd, &ps);
		
		SetTextColor(hdc, clrKolorTekstu);
		SetBkColor(hdc, clrKolorTla);
		TextOut(hdc, 50, 42, "Zam mnie!", 10);
		
		EndPaint(hWnd, &ps);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}

// Obsuga okienka dialogowego O programie
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}

// Obsuga okienka dialogowego aktywacji
INT_PTR CALLBACK DialogSerial(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{ 
	UNREFERENCED_PARAMETER(lParam);
	char * klucz, * kluczTxt;
	switch (message)
	{
	case WM_INITDIALOG:
		
		klucz = OdczytajKluczAktywacyjny();
		kluczTxt = KluczBinarnyNaTekstowy(klucz);
		SetDlgItemText(hDlg, IDC_NUMER_AKTYWACYJNY, kluczTxt);
		delete klucz;
		delete kluczTxt;
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			hasloWWW = new char[MAX_HASLO_WWW];
			GetDlgItemText(hDlg, IDC_EDIT_HASLO_WWW, hasloWWW, MAX_HASLO_WWW);

			EndDialog(hDlg, LOWORD(wParam));

			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}

// Obsuga okienka dialogowego z ptaniem o haslo
INT_PTR CALLBACK DialogHaslo(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{ 
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:	
		return (INT_PTR)TRUE;
	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			hasloWWW = new char[MAX_HASLO_WWW];
			GetDlgItemText(hDlg, IDC_EDIT_HASLO_WWW, hasloWWW, MAX_HASLO_WWW);
			EndDialog(hDlg, LOWORD(wParam));

			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}


// Pomocnicza funkcja konwertujca kolor RGB na tekst
void UtworzTekstKoloru(char * szMessage, COLORREF aColor, char * aHasloWWW)
{
	if(aHasloWWW != NULL) 
	{
		_asm
		{
			push aHasloWWW					// haslo WWW			
			push KLUCZ_PROG_ROZMIAR;		// rozmiar zabezpeiczanego kodu
			push offset ZabezpieczanyKod	// adres zabezpieczanego kodu
			call ZmodyfikujKod
			add esp, 12 
		}
	}
	else 
	{
		_asm
		{
			push KLUCZ_PROG_ROZMIAR;		// rozmiar zabezpeiczanego kodu
			push offset ZabezpieczanyKod	// adres zabezpieczanego kodu
			call PobierzKod
			add esp, 8 
		}
		return; // gdy robimy zrzut nie chcemy wykonywa kodu poniej
	}
	
ZabezpieczanyKod:
	switch(aColor)
	{
	case 0xFFFFFF:
		strcpy_s(szMessage, 40, "Biay");
		break;
	case 0x0000FF:
		strcpy_s(szMessage, 40, "Czerwony");
		break;
	case 0x808080:
		strcpy_s(szMessage, 40, "Szary");
		break;
	case 0x00FF00:
		strcpy_s(szMessage, 40, "Zielony");
		break;
	case 0x00FFFF:
		strcpy_s(szMessage, 40, "ty");
		break;
	case 0:
		strcpy_s(szMessage, 40, "Czarny");
		break;
	case 0xFF0000:
		strcpy_s(szMessage, 40, "Niebieski");
		break;
	default:
		strcpy_s(szMessage, 40, "Nieznany");
		break;
	}

}
